<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ultimate_Challenge_Leaderboard extends Model
{
    use HasFactory;

    protected $table = 'tbl_ultimate_challenge_leaderboard';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'ultimate_challenge_id' => 'integer',
        'total_questions' => 'integer',
        'questions_attended' => 'integer',
        'correct_answers' => 'integer',
        'percentage' => 'integer',
        'winning_coin' => 'integer',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
